﻿using System;
using RimWorld;
using Verse;
using System.Reflection;

namespace JTReplaceWalls
{
    //Looked at PetFollow for this atrribute
    [StaticConstructorOnStartup]
    class Vaccine
    {
        static Vaccine()
        {
            MethodInfo methodVanilla = typeof(Designator_Build).GetMethod("CanDesignateCell", BindingFlags.Instance | BindingFlags.Public);
            MethodInfo methodReplace = typeof(Designator_Build_JT).GetMethod("CanDesignateCell", BindingFlags.Instance | BindingFlags.Public);
            giveAutism(methodVanilla, methodReplace);
            Log.Message("JTReplaceWalls probably sucessfully replaced Designator_Build.CanDesignateCell(). Code stolen from CCL/RawCode.");
            
            methodVanilla = typeof(GenConstruct).GetMethod("PlaceBlueprintForBuild", BindingFlags.Instance | BindingFlags.Static | BindingFlags.Public);
            methodReplace = typeof(GenConstruct_JT).GetMethod("PlaceBlueprintForBuild_JT", BindingFlags.Instance | BindingFlags.Static | BindingFlags.Public);
            giveAutism(methodVanilla, methodReplace);
            Log.Message("JTReplaceWalls probably sucessfully replaced GenConstruct.PlaceBlueprintForBuild(). Code stolen from CCL/RawCode.");

            methodVanilla = typeof(GenConstruct).GetMethod("BlocksFramePlacement", BindingFlags.Instance | BindingFlags.Static | BindingFlags.Public);
            methodReplace = typeof(GenConstruct_JT).GetMethod("BlocksFramePlacement", BindingFlags.Instance | BindingFlags.Static | BindingFlags.Public);
            giveAutism(methodVanilla, methodReplace);
            Log.Message("JTReplaceWalls probably sucessfully replaced GenConstruct.BlocksFramePlacement(). Code stolen from CCL/RawCode.");

            methodVanilla = typeof(GenSpawn).GetMethod("SpawningWipes", BindingFlags.Instance | BindingFlags.Static | BindingFlags.Public);
            methodReplace = typeof(GenSpawn_JT).GetMethod("SpawningWipes", BindingFlags.Instance | BindingFlags.Static | BindingFlags.Public);
            giveAutism(methodVanilla, methodReplace);
            Log.Message("JTReplaceWalls probably sucessfully replaced GenSpawn.SpawningWipes(). Code stolen from CCL/RawCode.");

            /*methodVanilla = typeof(WorkGiver_ConstructDeliverResourcesToBlueprints).GetMethod("DeconstructExistingEdificeJob", BindingFlags.Instance | BindingFlags.NonPublic);
            methodReplace = typeof(WorkGiver_ConstructDeliverResourcesToBlueprints_JT).GetMethod("DeconstructExistingEdificeJob", BindingFlags.Instance | BindingFlags.NonPublic);
            giveAutism(methodVanilla, methodReplace);
            Log.Message("JTReplaceWalls probably sucessfully replaced WorkGiver_ConstructDeliverResourcesToBlueprints.DeconstructExistingEdificeJob(). Code stolen from CCL/RawCode.");
            */

            //The following is necessary so walls underneath will be removed when new wall is built, not done in XML for some compatibility
            //ThingDefOf.Wall.building.canPlaceOverWall = true; //Old version
            DefDatabase<ThingDef>.GetNamed("Wall").building.canPlaceOverWall = true;
            if (DefDatabase<ThingDef>.GetNamed("Embrasure", false) != null)
            {
                DefDatabase<ThingDef>.GetNamed("Embrasure").building.canPlaceOverWall = true;
                Designator_Build_JT.embrasure = true;
                Log.Message("JTReplaceWalls: detected Embrasure");
            }
        }

        //This shit stolen from CCL because I'm a pleb programmer. CCL got code from user RawCode.
        static unsafe void giveAutism(MethodInfo source, MethodInfo destination)
        {
            if (IntPtr.Size == sizeof(Int64))
            {
                // 64-bit systems use 64-bit absolute address and jumps
                // 12 byte destructive

                // Get function pointers
                long Source_Base = source.MethodHandle.GetFunctionPointer().ToInt64();
                long Destination_Base = destination.MethodHandle.GetFunctionPointer().ToInt64();

                // Native source address
                byte* Pointer_Raw_Source = (byte*)Source_Base;

                // Pointer to insert jump address into native code
                long* Pointer_Raw_Address = (long*)(Pointer_Raw_Source + 0x02);

                // Insert 64-bit absolute jump into native code (address in rax)
                // mov rax, immediate64
                // jmp [rax]
                *(Pointer_Raw_Source + 0x00) = 0x48;
                *(Pointer_Raw_Source + 0x01) = 0xB8;
                *Pointer_Raw_Address = Destination_Base; // ( Pointer_Raw_Source + 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09 )
                *(Pointer_Raw_Source + 0x0A) = 0xFF;
                *(Pointer_Raw_Source + 0x0B) = 0xE0;
            }
            else
            {
                // 32-bit systems use 32-bit relative offset and jump
                // 5 byte destructive
                // Get function pointers
                int Source_Base = source.MethodHandle.GetFunctionPointer().ToInt32();
                int Destination_Base = destination.MethodHandle.GetFunctionPointer().ToInt32();

                // Native source address
                byte* Pointer_Raw_Source = (byte*)Source_Base;

                // Pointer to insert jump address into native code
                int* Pointer_Raw_Address = (int*)(Pointer_Raw_Source + 1);

                // Jump offset (less instruction size)
                int offset = (Destination_Base - Source_Base) - 5;

                // Insert 32-bit relative jump into native code
                *Pointer_Raw_Source = 0xE9;
                *Pointer_Raw_Address = offset;
            }
            // done!
        }
    }
}
